import matplotlib.pyplot as plt

# Coordinates of the cities
cities = {
    0: (91, 59),
    1: (70, 43),
    2: (7, 46),
    3: (34, 77),
    4: (80, 35),
    5: (49, 3),
    6: (1, 5),
    7: (53, 3),
    8: (53, 92),
    9: (62, 17)
}

# Partial solution path
solution_path = [0, 4, 9, 7, 5, 6, 2, 1]

# Extracting x and y coordinates
x = [cities[i][0] for i in range(10)]
y = [cities[i][1] for i in range(10)]

plt.figure(figsize=(6,6))

# Plotting the cities
plt.scatter(x, y, color='red', s=60)

# Plotting the path
path_x = [cities[i][0] for i in solution_path]
path_y = [cities[i][1] for i in solution_path]
plt.plot(path_x, path_y, color='blue')

# Adding labels
for i in range(10):
    plt.text(x[i] + 1, y[i], str(i), color='black', fontsize=24)

plt.xlabel('X Coordinate', fontsize=24)
plt.ylabel('Y Coordinate', fontsize=24)
plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.grid(True)
plt.tight_layout()
# plt.show()

